#include <cstdio>

#include "main.h"
#include "keys_thread.h"

static const char* const TAG = "KEYS";
static uint16_t delay_ms = 2000U;

//------------------------------------------------------------------------------

VOID scanKeysThread(ULONG initial_input)
{
	(void)initial_input;

	HAL_GPIO_WritePin(POWER_4V_EN_GPIO_Port, POWER_4V_EN_Pin, GPIO_PIN_SET);
	HAL_GPIO_WritePin(POWER_5V_EN_GPIO_Port, POWER_5V_EN_Pin, GPIO_PIN_SET);
	HAL_GPIO_WritePin(POWER_10V_EN_GPIO_Port, POWER_10V_EN_Pin, GPIO_PIN_SET);

	while(1)
	{
		HAL_GPIO_TogglePin(RX1_LED_GPIO_Port, RX1_LED_Pin);
		//HAL_GPIO_WritePin(RX1_LED_GPIO_Port, RX1_LED_Pin, GPIO_PIN_RESET);
		//HAL_GPIO_WritePin(RX2_LED_GPIO_Port, RX2_LED_Pin, GPIO_PIN_RESET);

		tx_thread_sleep(delay_ms);

		//HAL_GPIO_WritePin(RX1_LED_GPIO_Port, RX1_LED_Pin, GPIO_PIN_SET);
		//HAL_GPIO_WritePin(RX2_LED_GPIO_Port, RX2_LED_Pin, GPIO_PIN_SET);

		// Calculating worse stack allocation
		TX_THREAD* current_thread = tx_thread_identify();
		printf("%s: Stack size: %lu, used: %u, free: %u\n", TAG, current_thread->tx_thread_stack_size,
			   (uint8_t*)current_thread->tx_thread_stack_ptr - (uint8_t*)current_thread->tx_thread_stack_start,
			   (uint8_t*)current_thread->tx_thread_stack_end - (uint8_t*)current_thread->tx_thread_stack_ptr);
	}
}

//------------------------------------------------------------------------------
