#ifndef __UTILS_H
#define __UTILS_H

#include <utility>

void printThreadStackInfo(const char* const TAG);

// This function converts all numbers from range [x0, x1] to range [y0, y1]
template <typename TYPE> TYPE Rescale(TYPE x, TYPE x1, TYPE x2, TYPE y1, TYPE y2, bool doNotExtrapolate = true)
{
	if (x1 > x2) std::swap(x1, x2);
	if (y1 > y2) std::swap(y1, y2);

	if (doNotExtrapolate)
	{
		if (x > x2) return y2;
		if (x < x1) return y1;
	}
	//SEGGER_RTT_printf(0, "x0 = %d, x1 = %d\n", x0, x1);
	return (((y2 - y1)*(x - x1))/(x2 - x1) + y1);
}


#endif /* __UTILS_H */
