#include <cstdio>
#include <cstdint>

#include "FreeRTOS.h"
#include "task.h"

#include "ff.h"
#include "fatfs.h"
#include "main_task.h"
#include "utils.h"


static const char* const TAG = "MAIN";

static constexpr uint16_t delay_ms = 5000;
static constexpr unsigned MAX_CHARS_IN_VOLUME_NAME = 12U;
static uint8_t volumeName[MAX_CHARS_IN_VOLUME_NAME];

//UINT ret;

static FATFS fs;     // Filesystem object


//------------------------------------------------------------------------------

[[noreturn]] void mainTaskStart(void *argument)
{
    FRESULT  r = f_mount(&fs, (const TCHAR*)"", 1);            // Mount the default drive
	if (r != FR_OK) printf("Cannot mount SD-card!\n");
	else printf("SD-card was mounted.\n");

	while(1)
	{
		vTaskDelay(pdMS_TO_TICKS(delay_ms));

		//printThreadStackInfo(TAG);
	}
}
