#include <cstdint>

#include "FreeRTOS.h"
#include "task.h"

#include "mb_slave_task.h"
#include "sysdata.h"
#include "modbus.h"
#include "usart.h"

static constexpr uint16_t delay_ms = 5U;

static UART_HandleTypeDef* const lb_usart = &huart2;
modbus_t lb_mbData;

void mbSlaveTaskStart(void* argument)
{
	UNUSED(argument);

	// Modbus Initialisierung
	//lb_usart = &huart2;
	sys_data_init();
	mbInit(&lb_mbData, 19200, MODBUS_UART_PARITY_EVEN, 1, lb_usart);


	while (1)
	{
		if (mbGetFrameComplete(&lb_mbData) == true)
		{
			if (mbSlaveCheckModbusRtuQuery(&lb_mbData) == RESPOND_TO_QUERY)
				mbSlaveProcessRtuQuery(&lb_mbData);
			else
				lb_usart->RxState = HAL_UART_STATE_BUSY_RX;
		}

		vTaskDelay(delay_ms);
	}

}