/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    adc.h
  * @brief   This file contains all the function prototypes for
  *          the adc.c file
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __ADC_H__
#define __ADC_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* USER CODE BEGIN Includes */

#include <stdio.h>

/* USER CODE END Includes */

extern ADC_HandleTypeDef hadc3;

/* USER CODE BEGIN Private defines */

#define ADC3_CHANNELS	(4U)
#define VREF			(3000U)

typedef union ADC3_data_t
{
	uint16_t Raw[ADC3_CHANNELS];
	struct
	{
		uint16_t Vbat;
		uint16_t Vref;
		uint16_t CPUTemp;
		uint16_t UBat;
	} Name;
} __attribute__((packed, aligned(32))) ADC3_data_t;

/* USER CODE END Private defines */

void MX_ADC3_Init(void);

/* USER CODE BEGIN Prototypes */

extern volatile uint16_t ADC3_values[2];

/* USER CODE END Prototypes */

#ifdef __cplusplus
}
#endif

#endif /* __ADC_H__ */

