/**
  ******************************************************************************
  * @file    balancer.h
  * @author  ECS - Falko Jahn
  * @version V1.0.0
  * @date    03-Feb-2021
  * @brief   Balancer Modul Treiber
  *
  *          Beschreibung          
  *          Dieses Modul enthlt die notwendigen Funktionen zur Stuerung des 
  *          DC/DC Converters (Flybackconverter)
  *
  * Starte timer zur Messung der Charge Time und der Charge Transfer Time
  * Charge Time bedeutet die Zeit zum Aufbau des Magnedfeldes. Also vom Einschalten
  * des Mosfets bis zum erreichen der Maximal Stroms.
  * Charge Transfer Time bedeutet die Zeit bis das Magnetfeld ber den Trafo auf 
  * auf der Sek. Seite entladen wurde.
  * Wir knnen das dedektieren indem wir auf der Prim. Seite die zurck refklektierte Spannung messen.
  * Die zurck reflektierte spannung am Mosfet Drain Ud ist nach dem ausschalten des MOSFETS zunchst:
  * Ud = Uin + Uout / Wicklungsverhltniss
  * Nach dem abmagentieseren ist die Spannung nur noch U= Uin.
  * Das bedeutet der Comparator sollte im Idealfall genau zwischen diesen beiden Punkten detektieren
  * Zu diesem Zweg wird die Eingangsspannung leicht erhht auf den Komperator gegeben
  * In der aktuellen Konfig mit Spannungsteiler 18k / 3k und Offset 2,5V ber 18k
  * mssen am ausgang mindestens ca. 7 anliegen um ber die Triggerschwelle zu kommen
  * Falls die minimale Ausgangsspannung kleiner werden soll, muss der Offset verringert werde

  ******************************************************************************
  */ 
#ifndef __BALANCER_H
#define __BALANCER_H


//--- INCLUDEs -----------------------------------------------------------------

//--- GLOBALE TYPE DEFS --------------------------------------------------------       
    
//--- GLOBALE DEFINES ----------------------------------------------------------


//--- GLOBALE VARIABLEN PROTOTYPEN ---------------------------------------------
    
//--- GLOBALE FUNKTIONS PROTOTYPEN ---------------------------------------------
/**
  * @brief  Init Funktion

  *         
  * Initialisiert die Komparatoren, damit der Flyback Konverter automatisch arbeitet
  * Initialisiert den DAC. ber den DAC wierd der maximale Strom vorgegeben.
  * Die beiden Flyback Trafos haben einen Stigungsstrom von 10,2 A
  * Daher darf der MAX Strom nicht mehr als ca. 20A betragen
  *
  *   
  * @param  Keine
  *              
  * @retval Kein
  */
void BALANCER_Init(void);


/**
  * @brief  Execute Funktion
  *         
  * Muss periodisch aufgerufen werden.
  * Prft die Zellspannung. Ist die Zellspannung grer der aktuellen
  * ausgleichsspannung, dann wird der Balancer Strom schrittweise erhht.
  *
  *   
  * @param  Keine
  *              
  * @retval Kein
  */
void BALANCER_Exec(void);



#endif