/**
  ******************************************************************************
  * @file    led.c
  * @author  ECS, Falko Jahn
  * @version V1.0.0
  * @date    29-Jan-2021
  * @brief   LED Modul 
  *          Beschreibung in Header
  ******************************************************************************
  */ 

// --- INCLUDES ----------------------------------------------------------------
#include "led.h"
#include "main.h"

//--- GGF. EXTERNE VARIABLEN ---------------------------------------------------  

//--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------
#define LED_OFF           0
#define LED_ON            (!LED_OFF)
//--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------
typedef struct
{
  uint32_t onTime;
  uint32_t offTime;
  uint32_t counter;
  uint32_t currentState;
} LED_TypeDef;

//--- DEFINATIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------
LED_TypeDef ledError;
LED_TypeDef ledFunction;

//--- LOKALE FUNKTIONS PROTOTYPEN ---------------------------------------------- 

    

//--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

//--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------
void LED_Init(void)
{
  
}

void LED_ErrorOn()
{
  HAL_GPIO_WritePin(LED_ERROR_GPIO_Port, LED_ERROR_Pin,GPIO_PIN_SET);
  HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin,GPIO_PIN_SET);
  ledError.currentState = LED_ON;
  ledError.counter = 0;
}

void LED_ErrorOff()
{
  HAL_GPIO_WritePin(LED_ERROR_GPIO_Port, LED_ERROR_Pin,GPIO_PIN_RESET);
  HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin,GPIO_PIN_RESET);
  ledError.currentState = LED_OFF;
  ledError.counter = 0;
}

void LED_ErrorToggle()
{
  HAL_GPIO_TogglePin(LED_ERROR_GPIO_Port, LED_ERROR_Pin);
  HAL_GPIO_TogglePin(BUZZER_GPIO_Port, BUZZER_Pin);
  
  ledError.currentState = !ledError.currentState;
  ledError.counter = 0;
}


void LED_ErrorStartBlink(int ontime, int offtime)
{
  ledError.onTime = ontime;
  ledError.offTime = offtime;
  HAL_GPIO_TogglePin(LED_ERROR_GPIO_Port, LED_ERROR_Pin);
  HAL_GPIO_TogglePin(BUZZER_GPIO_Port, BUZZER_Pin);
  ledError.currentState = !ledError.currentState;

  if (ledError.currentState == LED_ON) ledError.counter = ontime;
  if (ledError.currentState == LED_OFF) ledError.counter = offtime;

}

void LED_ErrorExec()
{
  if (ledError.counter > 0)
  {
      ledError.counter--;
      if (ledError.counter == 0)
      {
        if (ledError.currentState == LED_ON)
        {
          HAL_GPIO_WritePin(LED_ERROR_GPIO_Port, LED_ERROR_Pin,GPIO_PIN_RESET);
          HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin,GPIO_PIN_RESET);
          ledError.currentState = LED_OFF;
          ledError.counter = ledError.offTime;
        }
        else
        {
          HAL_GPIO_WritePin(LED_ERROR_GPIO_Port, LED_ERROR_Pin,GPIO_PIN_SET);
          HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin,GPIO_PIN_SET);
          ledError.currentState = LED_ON;
          ledError.counter = ledError.onTime;
        }
      }
  }
}

// ----- LED FUNCTION ------

void LED_FunctionOn()
{
  HAL_GPIO_WritePin(LED_FUNC_GPIO_Port, LED_FUNC_Pin,GPIO_PIN_SET);
  ledFunction.currentState = LED_ON;
  ledFunction.counter = 0;
}

void LED_FunctionOff()
{
  HAL_GPIO_WritePin(LED_FUNC_GPIO_Port, LED_FUNC_Pin,GPIO_PIN_RESET);
  ledFunction.currentState = LED_OFF;
  ledFunction.counter = 0;
}

void LED_FunctionToggle()
{
  HAL_GPIO_TogglePin(LED_FUNC_GPIO_Port, LED_FUNC_Pin);
  ledFunction.currentState = !ledFunction.currentState;
  ledFunction.counter = 0;
}

void LED_FunctionStartBlink(int ontime, int offtime)
{
  ledFunction.onTime = ontime;
  ledFunction.offTime = offtime;
  HAL_GPIO_TogglePin(LED_FUNC_GPIO_Port, LED_FUNC_Pin);
  ledFunction.currentState = !ledFunction.currentState;

  if (ledFunction.currentState == LED_ON) ledFunction.counter = ontime;
  if (ledFunction.currentState == LED_OFF) ledFunction.counter = offtime;

}

void LED_FunctionSetTimes(int ontime, int offtime)
{
  ledFunction.onTime = ontime;
  ledFunction.offTime = offtime;
}

void LED_FunctionExec()
{
  if (ledFunction.counter > 0)
  {
      ledFunction.counter--;
      if (ledFunction.counter == 0)
      {
        if (ledFunction.currentState == LED_ON)
        {
          HAL_GPIO_WritePin(LED_FUNC_GPIO_Port, LED_FUNC_Pin,GPIO_PIN_RESET);
          ledFunction.currentState = LED_OFF;
          ledFunction.counter = ledFunction.offTime;
        }
        else
        {
          HAL_GPIO_WritePin(LED_FUNC_GPIO_Port, LED_FUNC_Pin,GPIO_PIN_SET);
          ledFunction.currentState = LED_ON;
          ledFunction.counter = ledFunction.onTime;
        }
      }
  }
}



void LED_Test()
{
  LED_ErrorOn();
  HAL_Delay(1000);
  LED_ErrorOff();
  HAL_Delay(1000);

}

void LED_Exec()
{
  LED_ErrorExec();
  LED_FunctionExec();
}

