
// Wie OVP||OVP Modul
// Jedoch hier nur OVP



#include "stdio.h"
#include "mode_ovp.h"
#include "button.h"
#include "relais.h"
#include "main.h"
#include "leds.h"
#include "buzzer.h"
#include "chip_temperature.h"


typedef enum OVP_State_enum 
{
  OVP_OFF, 
  OVP_ON,
  OVP_MANUAL_ON, 
  OVP_ERROR
} OVP_state_t;


static OVP_state_t smState;


static void OVP_SM_Off(void)
{
  int faultInput;


  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }


  


  //Prüfe auf Wechsel des Modus AUTO / SM ON
  if (BUTTON_GetMode() == BUTTON_AUTO)
  {
    if (faultInput == 0) 
    {
      RELAIS_SetPuls();
      BUZZER_Beep(BUZZER_ON_TIME_CONFIRM);
      LEDS_GN_Blink_Start(LED_GN_ON_TIME_ON_MODE, LED_GN_OFF_TIME);
      printf("OVP_SM_Off: NEW_STATE: OVP_ON\n");
      smState = OVP_ON;

    }
    else   
    {
      //Wechsel nicht möglich. Fehler Eingang aktiv
      BUZZER_Beep(BUZZER_ON_TIME_REJECT);
      BUTTON_SetModeOff();
      //LEDS_RT_Blink_Start(LED_RT_ON_TIME_WARN_FAULT_INPUT, LED_GN_OFF_TIME); //Fehler Anzeigen
	  LEDS_RT_BlinkCode_Start(BLINK_CODE_ERROR_FAULT_INPUT, LED_RT_ON_TIME_WARN_FAULT_INPUT, LED_RT_OFF_TIME, LED_RT_OFF_TIME *5); //Fehler Anzeigen
      printf("OVP_SM_Off: NEW_STATE: OVP_ERROR_FAULT_INPUT\n");
      smState =OVP_ERROR;
    }
  }


  //Prüfe auf Wechsel in MANUAL ON Mode
  //Keine Fehlerüberprüfungen. In diesem Modus werdem alle Alarme ignoriert.
  if (BUTTON_GetMode() == BUTTON_MANUAL_ON)
  {
      
      RELAIS_SetPuls();
      BUZZER_Alarm_Start(BUZZER_ON_TIME_ALARM_MANUAL_MODE, BUZZER_OFF_TIME);
      LEDS_GN_On();
      LEDS_RT_BlinkCode_Start(BLINK_CODE_WARN_MANUAL, LED_RT_ON_TIME_WARN_MANUAL_MODE, LED_RT_OFF_TIME, LED_RT_OFF_TIME * 5); //Fehler Anzeigen
      printf("NEW_STATE: OVP_MANUAL_ON\n");
      smState = OVP_MANUAL_ON;
  }



}

static void OVP_SM_On(void)
{
  int faultInput = 0;
  static int ovpInput = 0;
  static int ovpTimeCounter = 0;
  static int oldtime;

  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }
  
  if ((HAL_GPIO_ReadPin(GPIO_INPUT_OVP_GPIO_Port, GPIO_INPUT_OVP_Pin) == GPIO_PIN_SET) ||  (HAL_GPIO_ReadPin(GPIO_INPUT_OVP_GPIO_Port, GPIO_INPUT_OVP_Pin) == GPIO_PIN_SET))
  {
    if (HAL_GetTick() != oldtime)
    {
      if (ovpTimeCounter < 5000) ovpTimeCounter++;
      if (ovpTimeCounter >= 5000)
      {
        ovpInput = 1;
        ovpTimeCounter=0;
      }
      oldtime = HAL_GetTick();
    }
  }

  if (HAL_GPIO_ReadPin(GPIO_INPUT_OVP_GPIO_Port, GPIO_INPUT_OVP_Pin) == GPIO_PIN_RESET) 
  {
//    if (HAL_GetTick() != oldtime)
//    {
//      ovpAndOvpInputTimeCounter++;
//      if (ovpAndOvpInputTimeCounter > 30000)
//      {
        ovpInput = 0;
        ovpTimeCounter=0;
//      }
//      oldtime = HAL_GetTick();
//    }
  }

  


  //Prüfe auf Fehlermode
  if (faultInput == 1)
  {
    RELAIS_ResetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_REJECT); //Warnung
    LEDS_GN_Off();
    LEDS_RT_BlinkCode_Start(BLINK_CODE_ERROR_FAULT_INPUT, LED_RT_ON_TIME_WARN_FAULT_INPUT, LED_RT_OFF_TIME, LED_RT_OFF_TIME *5); //Fehler Anzeigen
    BUTTON_SetModeOff(); //Damit nicht von alleine wieder eingeschaltet wird
    printf("FAULT INPUT EVENT DETECTED!\n");
    printf("NEW_STATE: OVP_ERROR\n");
    smState = OVP_ERROR;
  }

    if (CHIP_TEMPERATURE_GetTemp() > 80)
  {
	RELAIS_ResetPuls();
	BUZZER_Beep(BUZZER_ON_TIME_REJECT); //Warnung
	LEDS_GN_Off();
	LEDS_RT_BlinkCode_Start(BLINK_CODE_ERROR_TEMP, LED_RT_ON_TIME_WARN_TEMP, LED_GN_OFF_TIME, LED_GN_OFF_TIME *5); //Fehler Anzeigen
	BUTTON_SetModeOff(); //Damit nicht von alleine wieder eingeschaltet wird
	printf("NEW_STATE: MAINSWITCH_ERROR, Temp too high\n");
	smState = OVP_ERROR;          
  }


  //OVP oder OVP hat stattgefunden, und Relais ist ein, dann aus
  if ((ovpInput == 1) && (RELAIS_GetState() == 1)) 
  {
    RELAIS_ResetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_REJECT); //Warnung
    LEDS_GN_Off();    
    printf("OVP OFF!\n");
    printf("NEW_STATE: OVP_Auto On, Relais off\n");
    
  }

  //KEIN OVP und keine OVP Abschaltung, Relais ist aber noch aus, dann einschalten
  if ((ovpInput == 0) && (RELAIS_GetState() == 0))
  {
    RELAIS_SetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_CONFIRM); //Warnung
    LEDS_GN_Off();
    LEDS_GN_Blink_Start(LED_GN_ON_TIME_ON_MODE, LED_GN_OFF_TIME);
    printf("OVP ON!\n");
    printf("NEW_STATE: OVP_OVP_Auto On, Relais on\n");
    
  }

  // Prüfe Wechsel in off mode
  if (BUTTON_GetMode() == BUTTON_OFF)
  {
    //Ausschalten muss immer möglich sein
    RELAIS_ResetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_CONFIRM); //Bestätigung
    LEDS_GN_Off();
    LEDS_RT_Off();
    printf("NEW_STATE: OVP_OFF\n");
    smState = OVP_OFF;
	//Damit beim drücken auf on erstmal eingeschaltet wird
	ovpTimeCounter=0;
	ovpInput = 0;
  }


}

static void OVP_SM_ManualOn(void)
{
  // Prüfe Wechsel in off mode
  if (BUTTON_GetMode() == BUTTON_OFF)
  {
    //Ausschalten muss immer möglich sein
    RELAIS_ResetPuls();
    BUZZER_Alarm_Stop();
    LEDS_GN_Off();
    LEDS_RT_Off();
    printf("NEW_STATE: OVP_OFF\n");
    smState = OVP_OFF;
  }

}

static void OVP_SM_Error(void)
{
  int faultInput;
  int ovpAndOvpInput;

  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }



  //Prüfe auf Wechsel des Modus AUTO / SM ON
  if (BUTTON_GetMode() == BUTTON_AUTO)
  {
    if (faultInput == 0) 
    {
      RELAIS_SetPuls();
      BUZZER_Beep(BUZZER_ON_TIME_CONFIRM);
      LEDS_GN_Blink_Start(LED_GN_ON_TIME_ON_MODE, LED_GN_OFF_TIME);
      LEDS_RT_Off(); //Fehler löschen
      printf("NEW_STATE: OVP_ON\n");
      smState = OVP_ON;
    }
    else
    {
      //Wechsel nicht möglich. Fehler Eingang weiterhin aktiv
      BUZZER_Beep(BUZZER_ON_TIME_REJECT);
      BUTTON_SetModeOff();
    }
  }

  //Prüfe auf Wechsel in MANUAL ON Mode
  //Keine Fehlerüberprüfungen. In diesem Modus werdem alle Alarme ignoriert.
  if (BUTTON_GetMode() == BUTTON_MANUAL_ON)
  {
      
      RELAIS_SetPuls();
      BUZZER_Alarm_Start(BUZZER_ON_TIME_ALARM_MANUAL_MODE, BUZZER_OFF_TIME);
      LEDS_GN_On();
      LEDS_RT_Off();
      LEDS_RT_BlinkCode_Start(BLINK_CODE_WARN_MANUAL, LED_RT_ON_TIME_WARN_MANUAL_MODE, LED_RT_OFF_TIME, LED_RT_OFF_TIME *5); //Fehler Anzeigen
      printf("NEW_STATE: OVP_MANUAL_ON\n");
      smState = OVP_MANUAL_ON;
  }



}



void MODE_OVP_Exec(void)
{

  

  switch (smState)
  {
    case OVP_OFF:
     OVP_SM_Off();
    break;

    case OVP_ON:
      OVP_SM_On();
    break;

    case OVP_MANUAL_ON:
      OVP_SM_ManualOn();
    break;

    case OVP_ERROR:
      OVP_SM_Error();
    break;

    default:
    break;
  }
}


