/******************************************************************************
*
* @file    battery_voltage.c
* @author  ECS, Falko Jahn
* @version V1.0.0
* @date    2020-05-01
* @brief
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include "battery_voltage.h"
#include "main.h"
#include "sysdata.h"
#include <stdio.h>
//	--- EXTERNE VARIABLEN --------------------------------------------------------

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------
#define BATTERY_VOLTAGE_FILTER  32



//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------

//	--- LOKALE FUNKTIONS PROTOTYPEN ----------------------------------------------

//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------


void BATTERY_VOLTAGE_Exec(int32_t newVal)
{
  static int measCounter;
  static unsigned long avgSum = 0;
  int32_t avgVal;
  if (measCounter < INT32_MAX) measCounter++;


  // Filterlängen in 2er-Potenzen --> Compiler optimiert
  avgSum -= avgSum / BATTERY_VOLTAGE_FILTER;
  avgSum += newVal;
  avgVal =  avgSum / BATTERY_VOLTAGE_FILTER;

  


  //Umrechung auf Eingangsspannung am Gerät mit Teiler
  sys_data.s.values.batteryVoltage = ((avgVal-BATTERY_VOLTAGE_ADC_OFFSET) * VREF * BATTERY_VOLTAGE_VOLTAGE_DIVIDER ) / BATTERY_VOLTAGE_ADC_RESOLUTION;

  


  //Max und Minwert
  if (measCounter > BATTERY_VOLTAGE_FILTER * 10)
  {
    if (sys_data.s.values.batteryVoltage > sys_data.s.values.batteryVoltageMax)
    {
      sys_data.s.values.batteryVoltageMax = sys_data.s.values.batteryVoltage;
    }
    if (sys_data.s.values.batteryVoltage < sys_data.s.values.batteryVoltageMin)
    {
      sys_data.s.values.batteryVoltageMin = sys_data.s.values.batteryVoltage;
    }
  }



  //Berechnung schnelle Wert ohne Glättung:
  //Umrechung auf Eingangsspannung am Gerät mit Teiler
  sys_data.s.values.fast_voltage = ((newVal-BATTERY_VOLTAGE_ADC_OFFSET) * VREF * BATTERY_VOLTAGE_VOLTAGE_DIVIDER ) / BATTERY_VOLTAGE_ADC_RESOLUTION;



}

/*************************** End of file ****************************/