/******************************************************************************
*
* @file    ref_voltage.c
* @author  ECS, Falko Jahn
* @version V1.0.0
* @date    2020-05-01
* @brief       
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include "main.h"
#include "sysdata.h"
//	--- EXTERNE VARIABLEN -------------------------------------------------------- 

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------
#define REF_FILTER              64
//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------

//	--- LOKALE FUNKTIONS PROTOTYPEN ---------------------------------------------- 
/*
* @brief
* @param	kein
* @retval	kein
*/

//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------



//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------
void REF_VOLTAGE_Exec(uint32_t newval)
{
   static unsigned long avgsum = 0;
   uint32_t avgval;
   // Filterlängen in 2er-Potenzen --> Compiler optimiert 
   avgsum -= avgsum / REF_FILTER;
   avgsum += newval;
   avgval = avgsum / REF_FILTER;

  // Messung Externe Spannung basierend auf 3,3V Versorgungsspannung
  // Nur für Debug Zwecke
  sys_data.s.values.voltageVref =  (avgval * 3300) / 65536;
  
  // Ermittlung Vdd als Referenz
  sys_data.s.values.realVdd =  3000L * 65536 / avgval;;
}
/*************************** End of file ****************************/