/******************************************************************************
*
* @file    outputs.h
* @author  ECS, Falko Jahn
* @version V1.0.0
* @date    2020-05-26
* @brief   Schalten von LVP und OVP Ausgänge    
*
******************************************************************************/
#ifndef __OUTPUTS_H
#define __OUTPUTS_H

//--- INCLUDEs -----------------------------------------------------------------

//--- GLOBALE TYPE DEFS --------------------------------------------------------

//--- GLOBALE DEFINES ----------------------------------------------------------
#define OUTPUTS_DISCHARGE_ALLOWED				GPIO_PIN_SET
#define OUTPUTS_DISCHARGE_NOT_ALLOWED			GPIO_PIN_RESET

#define OUTPUTS_CHARGE_ALLOWED					GPIO_PIN_SET
#define OUTPUTS_CHARGE_NOT_ALLOWED				GPIO_PIN_RESET

#define OUTPUTS_LVP_UNKNOWN						-1
#define OUTPUTS_LVP_OK							0
#define OUTPUTS_LVP_BATTERY_UNDERVOLTAGE		1
#define OUTPUTS_LVP_OVERCURRENT					2
#define OUTPUTS_LVP_SHUNT_OVERTEMPERATURE		3
#define OUTPUTS_LVP_CHIP_OVERTEMPERATURE		4
#define OUTPUTS_LVP_SHUNT_UNDERTEMPERATURE		5
#define OUTPUTS_LVP_CHIP_UNDERTEMPERATURE		6
#define OUTPUTS_LVP_SHORT_PROTECTION			7

#define OUTPUTS_OVP_UNKNOWN						-1
#define OUTPUTS_OVP_OK							0
#define OUTPUTS_OVP_BATTERY_OVERVOLTAGE			1
#define OUTPUTS_OVP_OVERCURRENT					2
#define OUTPUTS_OVP_SHUNT_OVERTEMPERATURE		3
#define OUTPUTS_OVP_CHIP_OVERTEMPERATURE		4
#define OUTPUTS_OVP_SHUNT_UNDERTEMPERATURE		5
#define OUTPUTS_OVP_CHIP_UNDERTEMPERATURE		6
#define OUTPUTS_OVP_SHORT_PROTECTION			7

#define OUTPUTS_LVP_MODE_AUTO					0U
#define OUTPUTS_LVP_MODE_MANUAL_ON				1U
#define OUTPUTS_LVP_MODE_MANUAL_OFF				2U

#define OUTPUTS_OVP_MODE_AUTO					0U
#define OUTPUTS_OVP_MODE_MANUAL_ON				1U
#define OUTPUTS_OVP_MODE_MANUAL_OFF				2U

//--- GLOBALE VARIABLEN PROTOTYPEN ---------------------------------------------

//--- GLOBALE FUNKTIONS PROTOTYPEN ---------------------------------------------

void OUTPUTS_Init(void);
/*
* @brief	
* @param	kein
* @retval	kein
*/
void OUTPUTS_CheckLVP(void);


/*
* @brief	
* @param	kein
* @retval	kein
*/
void OUTPUTS_CheckOVP(void);


void OUTPUTS_CheckAUX(void);
#endif // __OUTPUTS_H