//Secondary Protection Modus
//Schaltet ab: Wenn LVP und OVP gleichzeitig kommen. --> Kein Auto Reconnect!
//Schaltet ab: Wenn Fault kommt --> keine automatisches Reconnect!

#include "mode_secondaryprotection.h"


#include "stdio.h"
#include "mode_secondaryprotection.h"
#include "button.h"
#include "relais.h"
#include "main.h"
#include "leds.h"

  //Prüfe FAULT Eingang


void MODE_SECONDARYPROTECTION_Exec(void)
{

  int faultInput = 0;
  int lvpAndOvpInput = 0;
  static int faultMode = 0;


  //Prüfe Fehler
  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;

    if (faultMode == 0)
    {
      faultMode = 1;
      LEDS_RT_Blink_Start(1000, 1000);         
      printf("FAULT DETECTED!\n");
    }

    if (BUTTON_GetMode() != BUTTON_OFF)
    {
       BUTTON_SetModeOff();
    }

    if (RELAIS_GetState() == 1)
    {
      printf("RESET RELAIS: FAULT DETECTED!\n");
      RELAIS_ResetPuls();        
    }      
  }
  else
  {
    faultInput = 0;
  } 

  if ((HAL_GPIO_ReadPin(GPIO_INPUT_LVP_GPIO_Port, GPIO_INPUT_LVP_Pin) == GPIO_PIN_SET) &&  (HAL_GPIO_ReadPin(GPIO_INPUT_OVP_GPIO_Port, GPIO_INPUT_OVP_Pin) == GPIO_PIN_SET))
  {
    lvpAndOvpInput = 1;

    if (faultMode == 0)
    {
      faultMode = 1;
      LEDS_RT_Blink_Start(500, 1000);        
      printf("FAULT DETECTED!\n");
    }

    if (BUTTON_GetMode() != BUTTON_OFF)
    {
       BUTTON_SetModeOff();
    }

    if (RELAIS_GetState() == 1)
    {
      printf("RESET RELAIS: SECONDARY PROTECTION (OVP AND LVP = LOW)!\n");
      RELAIS_ResetPuls();
    }      
  }
  else
  {
    lvpAndOvpInput = 0;
  } 



  //Prüfen ob ausgeschaltet werden muss
  if (RELAIS_GetState() == 1)
  {
    if (BUTTON_GetMode() == BUTTON_OFF)       
    {
      RELAIS_ResetPuls();
    } 
  }


  //Prüfen ob eingeschaltet werden kann
  if ((RELAIS_GetState() == 0) && (faultInput == 0) && (lvpAndOvpInput == 0))
  {
    
    if (BUTTON_GetMode() == BUTTON_MANUAL_ON) 
    {      
      LEDS_RT_Off(); //Falls im LED im Fehlermode, so können wir diese jetzt wieder ausschalten
      faultMode = 0;
      RELAIS_SetPuls();
      
    } 
    else if (BUTTON_GetMode() == BUTTON_AUTO)
    {
      LEDS_RT_Off(); //Falls im LED im Fehlermode, so können wir diese jetzt wieder ausschalten
      faultMode = 0;
      RELAIS_SetPuls();
    } 
  }
}
