#include "main.h"
#include "leds.h"

unsigned int onTimeCounterGN;
unsigned int offTimeCounterGN;
unsigned int onTimeGN;
unsigned int offTimeGN;
unsigned int blinkModeGN;


unsigned int onTimeCounterRT;
unsigned int offTimeCounterRT;
unsigned int onTimeRT;
unsigned int offTimeRT;
unsigned int blinkModeRT;

void LEDS_Exec(void)
{

  if (onTimeCounterGN > 0)
  {
    onTimeCounterGN--;
    if (onTimeCounterGN == 0)
    {
      HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ON_GPIO_Port, GPIO_OUTPUT_LED_ON_Pin, GPIO_PIN_RESET);

      if (blinkModeGN == 1) offTimeCounterGN = offTimeGN;
    }
  }

  if (offTimeCounterGN > 0)
  {
    offTimeCounterGN--;
    if (offTimeCounterGN == 0)
    {
      HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ON_GPIO_Port, GPIO_OUTPUT_LED_ON_Pin, GPIO_PIN_SET);
      onTimeCounterGN = onTimeGN;
    }
  }


  // --- LED ROT ---
  if (onTimeCounterRT > 0)
  {
    onTimeCounterRT--;
    if (onTimeCounterRT == 0)
    {
      HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ERROR_GPIO_Port, GPIO_OUTPUT_LED_ERROR_Pin, GPIO_PIN_RESET);

      if (blinkModeRT == 1) offTimeCounterRT = offTimeRT;
    }
  }

  if (offTimeCounterRT > 0)
  {
    offTimeCounterRT--;
    if (offTimeCounterRT == 0)
    {
      HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ERROR_GPIO_Port, GPIO_OUTPUT_LED_ERROR_Pin, GPIO_PIN_SET);
      onTimeCounterRT = onTimeRT;
    }
  }
}

// --- Steuerfunktionen LED grün ------------
void LEDS_GN_On(void)
{
  HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ON_GPIO_Port, GPIO_OUTPUT_LED_ON_Pin, GPIO_PIN_SET);

  blinkModeGN = 0; // Blinkmode zurücksetzen, falls es eingeschaltet war
  onTimeCounterGN = 0;
  offTimeCounterGN = 0;
}



void LEDS_GN_Flash(unsigned int time)
{
  HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ON_GPIO_Port, GPIO_OUTPUT_LED_ON_Pin, GPIO_PIN_SET);
  onTimeCounterGN = time;
}

void LEDS_GN_Blink_Start(unsigned int on, unsigned int off )
{
  onTimeGN = on;
  offTimeGN = off;
  blinkModeGN = 1;

  HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ON_GPIO_Port, GPIO_OUTPUT_LED_ON_Pin, GPIO_PIN_SET);
  onTimeCounterGN = on;
}

void LEDS_GN_Off(void)
{
  HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ON_GPIO_Port, GPIO_OUTPUT_LED_ON_Pin, GPIO_PIN_RESET);
  blinkModeGN = 0;
  offTimeCounterGN = 0;
  onTimeCounterGN = 0;
}



// --- Steuerfunktionen LED rot ------------
void LEDS_RT_On(void)
{
  HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ERROR_GPIO_Port, GPIO_OUTPUT_LED_ERROR_Pin, GPIO_PIN_SET);

  blinkModeRT = 0; // Blinkmode zurücksetzen, falls es eingeschaltet war
  onTimeCounterRT = 0;
  offTimeCounterRT = 0;
}



void LEDS_RT_Flash(unsigned int time)
{
  HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ERROR_GPIO_Port, GPIO_OUTPUT_LED_ERROR_Pin, GPIO_PIN_SET);
  onTimeCounterRT = time;
}

void LEDS_RT_Blink_Start(unsigned int on, unsigned int off )
{
  onTimeRT = on;
  offTimeRT = off;
  blinkModeRT = 1;

  HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ERROR_GPIO_Port, GPIO_OUTPUT_LED_ERROR_Pin, GPIO_PIN_SET);
  onTimeCounterRT = on;
}

void LEDS_RT_Off(void)
{
  HAL_GPIO_WritePin(GPIO_OUTPUT_LED_ERROR_GPIO_Port, GPIO_OUTPUT_LED_ERROR_Pin, GPIO_PIN_RESET);
  blinkModeRT = 0;
  offTimeCounterRT = 0;
  onTimeCounterRT = 0;
}